/*
  Trained via Tensorflow: 21 epochs | 472 parameters (bytes)
  Testing  data accuracy: 0.9160 - loss: 0.2740
  Training data accuracy: 0.9128 - loss: 0.2837
*/

#define NumberOf(arg) ((unsigned int) (sizeof (arg) / sizeof (arg [0]))) // calculates the number of layers (in this case 3)
#define _1_OPTIMIZE 0B11011010 // https://github.com/GiorgosXou/NeuralNetworks#define-macro-properties
#define _2_OPTIMIZE 0B00100100 // MULTIPLE_BIASES_PER_LAYER + int8_t quantization
#define Q_FLOAT_RANGE 2.0      // Our Float32 weights are in the range of [-1,1]
#define USE_RNN__NB            // Makes (vanilla)-RNN the core-architecture of your NeuralNetwork. (NB = NO_BACKPROP support)
#define SELU                   // Defines core activation-function of your NeuralNetwork.
#include <NeuralNetwork.h>


// Images of handwritten Numbers\Digits in byte form. 
const PROGMEM byte handwritten[4][28][28] = { 
{ // NUMBER: 4
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0, 50,224,  0,  0,  0,  0,  0,  0,  0, 70, 29,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,121,231,  0,  0,  0,  0,  0,  0,  0,148,168,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  4,195,231,  0,  0,  0,  0,  0,  0,  0, 96,210, 11,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0, 69,252,134,  0,  0,  0,  0,  0,  0,  0,114,252, 21,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0, 45,236,217, 12,  0,  0,  0,  0,  0,  0,  0,192,252, 21,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,168,247, 53,  0,  0,  0,  0,  0,  0,  0, 18,255,253, 21,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0, 84,242,211,  0,  0,  0,  0,  0,  0,  0,  0,141,253,189,  5,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,169,252,106,  0,  0,  0,  0,  0,  0,  0, 32,232,250, 66,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0, 15,225,252,  0,  0,  0,  0,  0,  0,  0,  0,134,252,211,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0, 22,252,164,  0,  0,  0,  0,  0,  0,  0,  0,169,252,167,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  9,204,209, 18,  0,  0,  0,  0,  0,  0, 22,253,253,107,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,169,252,199, 85, 85, 85, 85,129,164,195,252,252,106,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0, 41,170,245,252,252,252,252,232,231,251,252,252,  9,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0, 49, 84, 84, 84, 84,  0,  0,161,252,252,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,127,252,252, 45,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,253,253,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,127,252,252,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,135,252,244,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,232,236,111,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,179, 66,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
},
{ // NUMBER: 7
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0, 38,113,113,113,114,238,253,253,253,255,206, 88,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0, 57, 85,147,234,252,252,252,253,252,252,252,252,253,252,246, 75,  0, 0,0,0,0},
    {0,0,0,0, 0, 67,197,234,252,253,252,252,252,252,196,195,195,195,195,253,252,252, 84,  0, 0,0,0,0},
    {0,0,0,0, 0, 85,252,252,252,225,223,114, 84, 84,  0,  0,  0,  0, 16,253,252,214, 28,  0, 0,0,0,0},
    {0,0,0,0, 0, 38,221,157,112,  0,  0,  0,  0,  0,  0,  0,  0, 16,203,253,252,118,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 26,207,253,255,168,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,104,252,252,215, 33,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 67,240,252,220, 31,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 29,181,252,217, 37,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,253,252,252, 84,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0, 76,191,255,215,110,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0, 19,196,252,253,121,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0, 67,209,252,252, 56,  6,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0, 29,181,252,217, 84,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,253,252,252, 84,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0, 13,191,255,215, 31,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,154,252,253,121,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0, 13,187,252,133,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0, 57,252,252,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0, 57,252,252,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},  
},
{ // NUMBER: 0
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0, 61,  3, 42,118,193,118,118, 61,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0, 14,179,245,236,242,254,254,254,254,245,235, 84,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,151,254,254,254,213,192,178,178,180,254,254,241, 46,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0, 43,235,254,226, 64, 28, 12,  0,  0,  2,128,252,255,173, 17,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0, 56,254,253,107,  0,  0,  0,  0,  0,  0,  0,134,250,254, 75,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0, 63,254,158,  0,  0,  0,  0,  0,  0,  0,  0,  0,221,254,157,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,194,254,103,  0,  0,  0,  0,  0,  0,  0,  0,  0,150,254,213,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0, 34,220,239, 58,  0,  0,  0,  0,  0,  0,  0,  0,  0, 84,254,213,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,126,254,171,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 84,254,213,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,214,239, 60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 84,254,213,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,214,199,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 84,254,213,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0, 11,219,199,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 84,254,213,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0, 98,254,199,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,162,254,209,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0, 98,254,199,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 51,238,254, 75,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0, 98,254,199,  0,  0,  0,  0,  0,  0,  0,  0,  0, 51,165,254,195,  4,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0, 66,241,199,  0,  0,  0,  0,  0,  0,  0,  0,  3,167,254,227, 55,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,214,213, 20,  0,  0,  0,  0,  0, 46,152,202,254,254, 63,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,214,254,204,180,180,180,180,180,235,254,254,234,156, 10,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0, 81,205,254,254,254,254,254,254,254,252,234,120,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0, 26,210,254,254,254,254,254,153,104,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,}
},
{ // NUMBER: 3
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0, 67,128,188,254,254,255,254,254,181,123, 38,  3,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0, 94,249,251,202,136, 88, 89,136,136,160,230,253,186, 21,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0, 22,235,193, 60,  0,  0,  0,  0,  0,  0,  0, 15, 99,214,205,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0, 88,235, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 65,253, 49,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0, 25,121,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,236, 79,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,107,253, 43,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,118,247,174,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 49,211,249,144,  8,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  2, 20, 62, 98,152,175,242,254,211, 85,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0, 20,253,253,253,254,253,253,253,207, 57,  6,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  9,117,117,117, 63, 51,117,140,236,253,220, 95,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 14, 92,241,253,229, 60,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,121,248,230, 51,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 53,244,203,  3, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,153,253, 19, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,141,253, 19, 0,0,0,0},
    {0,0,0,0, 0,13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   5, 44,134,254,189,  0, 0,0,0,0},
    {0,0,0,0,16,231,112, 40, 25,  0,  0,  0,  0,  0,  0, 25, 40,100,197,253,208,125, 27,  0, 0,0,0,0},
    {0,0,0,0, 3,168,253,253,239,215,172,136,191,215,215,238,254,253,253,150,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  3, 62,122,175,187,229,253,254,193,175,175, 98, 97, 31,  2,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0}, 
},
}; // ^^^^^^ (images*(rows*pixels)) = (4*(28*28)) = 3136 Bytes 


const PROGMEM int8_t biases[] = {
  -90 ,-24 ,-66 , 24 ,-41 ,
  -125, 34 ,-112,-40 , 110, 60 ,-95 ,-16 ,
  -126, 13 ,-108,-91 ,-8  , 83 ,-127,-41 , 118, 57
};

const PROGMEM int8_t weights[] = {
  // Layer 0 -> 1
   127,-125,-19 ,-48 , 59 , 59 , 48 , 50 , 50 , 64 , 64 , 64 , 75 , 73 , 60 , 46 , 50 , 56 , 33 , 26 , 24 , 19 , 24 , 18 , 30 , 25 , 46 ,-65 ,
   93 ,-85 , 58 , 23 ,-38 ,
  -27 , 117,-26 , 34 , 35 , 11 , 32 , 30 , 36 , 41 , 32 , 41 , 48 , 73 , 73 , 65 , 66 , 48 , 43 , 36 , 31 , 27 , 32 , 13 , 10 , 8  , 11 ,-127,
   31 , 67 , 37 , 57 , 64 ,
   100,-101,-121, 25 ,-84 ,-127,-127,-127,-123,-103,-107,-83 , 27 , 124, 86 , 52 , 32 , 4  , 11 , 26 , 17 ,-33 , 3  , 5  ,-1  , 24 , 112, 127,
  -48 , 20 ,-26 ,124 ,-62 ,
   13 ,-91 , 25 ,-54 ,-63 ,-88 ,-79 ,-111,-121,-121,-127,-127,-127,-103,-39 ,-26 ,-1  , 1  , 12 , 0  ,-13 , 9  ,-17 ,-38 , 9  ,-44 , 59 ,-44 ,
  -13 , 1  ,-20 , 0  ,-15 ,
  -19 ,-127, 2  , 25 ,-6  , 17 ,-1  , 10 , 20 , 31 , 37 , 49 , 14 ,-32 ,-48 ,-69 ,-86 ,-103,-105,-119,-124,-127,-127,-123,-100, 44 , 112, 118,
   14 , 10 , 56 ,-82 , 47 ,

  // Layer 1 -> 2
  -79 ,-68 , 20 , 127, 16 ,
   93 , 9  ,-73 ,-6  , 32 , 11 ,-75 ,-26 ,
  -84 ,-36 ,108 , 125, 78 ,
  -87 , 47 ,-43 , 38 ,-42 ,-27 , 19 ,-71 ,
   69 , 41 , 16 , 90 , 35 ,
   16 , 77 , 79 ,-72 ,-46 ,111 , 27 ,-69 ,
   68 ,-12 ,-2  ,-29 , 26 ,
   49 , 59 ,-60 , 75 ,-32 ,-14 , 14 ,108 ,
   106, 3  ,-11 , 20 , 87 ,
  -26 , 37 , 12 , 2  , 27 , 13 ,-15 ,-35 ,
  -55 ,-71 ,125 , 107, 47 ,
  -24 ,-33 , 14 , 3  , 70 ,-66 , 81 , 33 ,
   53 ,-8  ,-64 ,-116, 5  ,
  -12 ,-42 , 18 ,-4  ,-13 ,-34 , 74 ,-5  ,
   40 , 4  ,-120,-73 , 8  ,
  -35 ,-38 , 86 ,-16 ,-76 , 64 ,-78 , 35 ,

  // Layer 2 -> 3
  -44 ,-74 , 21 , 36 ,-78 ,-67 , 9  ,-37 ,
   74 ,-52 ,-31 , 24 ,-37 , 13 ,-39 , 8  , 32 ,-5  ,
   72 ,-26 , 65 ,-19 , 43 ,-120,-5  , 92 ,
  -26 , 110,-16 ,-7  ,-27 , 17 ,-12 ,-3  ,-63 ,-16 ,
  -8  ,-18 , 42 ,-1  , 49 , 36 ,-21 , 52 ,
  -6  , 31 ,102 ,-29 ,-3  , 7  ,-19 , 32 ,-38 ,-23 ,
  -33 ,-12 , 34 ,-86 ,-45 ,-12 , 33 ,-31 ,
  -14 ,-2  , 49 , 79 ,-5  , 33 , 36 ,-16 ,-3  , 15 ,
   41 , 35 ,-33 , 34 , 40 ,-37 , 1  ,-42 ,
  -31 , 10 , 14 ,-9  , 84 , 18 ,-2  ,-26 , 32 ,-11 ,
  -59 , 13 , 2  ,-1  ,-21 ,-15 , 21 , 10 ,
  -40 , 20 ,-29 , 37 , 33 , 65 ,-9  ,-1  , 17 , 10 ,
   14 ,-79 ,-27 , 42 , 27 ,-126, 37 , 44 ,
  -10 , 2  ,-37 ,-24 ,-27 ,-18 , 26 ,-118, 48 ,-22 ,
  -8  ,-10 ,-50 ,-12 ,-35 ,-70 ,-1  ,-66 ,
   11 , 5  ,-6  , 3  ,-10 , 54 , 1  , 83 , 10 ,-15 ,
   47 , 25 , 65 ,-47 ,-21 , 84 , 37 , 24 ,
  -44 ,-8  ,-15 ,-12 , 8  ,-4  ,-6  , 18 , 34 ,-83 ,
  -56 , 56 ,-24 ,-23 ,-14 ,-37 ,-7  , 31 ,
  -81 ,-6  , 6  ,-51 , 33 , 43 ,-7  , 36 ,-37 , 30 ,
};

const unsigned int layers[] = {28, 5, 8, 10};
float *output; // 4th layer's output(s)

unsigned long timestamp;


unsigned int maxOutput(){
  unsigned int maxi=0;
  for (unsigned int i = 0; i < 10; i++)
    if (output[i] > output[maxi])
      maxi = i;
  return maxi;
}


void setup()
{
  Serial.begin(9600);
  while (!Serial){ };

  // Creating a NeuralNetwork with pretrained Weights and Biases
  NeuralNetwork NN(layers, weights, biases, NumberOf(layers));
  //Goes through each image
  for (unsigned int image = 0; image < 4; image++){
    timestamp = millis();  
    // Goes through each row (total of [28-Rows * 28-Pixel])     
    for (unsigned int row = 0; row < 28; row++){
      // Feedfowards individually each pixel of an image, and then: returns the output(s).
      for (unsigned int pixel=0; pixel < 28;  pixel++){
        output = NN.FeedForward_Individual(pgm_read_byte(&handwritten[image][row][pixel]) / 255.0); // (255 is used to normalize pixels between [0,1])
      }
    }
    // Prints the most probable Output (maxOutput) and afterwards it resets the internal hidden-states of the RNN (resetStates) for the next image
    Serial.println((String)"Predicted [" + (maxOutput()) + "] - Under " + (millis() - timestamp) + " milliseconds.");
    NN.resetStates();
  }
}
void loop(){}



